/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.action;

import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.human.dto.MKihonDto;

import jp.mosp.kintai.dao.MYukyuDao;
import jp.mosp.kintai.dto.MYukyuDto;

import jp.mosp.payroll.vo.YukyuPersonalCardVo;

public class YukyuPersonalCardAction extends MosPAction {

	// R}h
	private static final String CMD_YUKYU_PERSONAL_SHOW   	= "P1120";	// \
	private static final String CMD_YUKYU_PERSONAL_UPDATE 	= "P1130";	// XV

	/**
	 * RXgN^
	 */
	public YukyuPersonalCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		YukyuPersonalCardVo vo;
		vo = (YukyuPersonalCardVo)getStoredVo(CommonConst.VO_YUKYU_PERSONAL);
		if (vo == null) {
			vo = new YukyuPersonalCardVo();
		}
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		storeVo(CommonConst.VO_YUKYU_PERSONAL, vo);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DBRlNV擾
		getConnection();
		// DTO̎擾
		MYukyuDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof MYukyuDto ? (MYukyuDto)obj : null;
		vo.setParams(request);
		// R}h̏
		if (cmd.equals(CMD_YUKYU_PERSONAL_SHOW)) {
			// ΏێЈݒ
			vo.setSelectKCode(key1);
			// \
			dto = show(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_YUKYU_PERSONAL_UPDATE)) {
			// XV
			dto = update(vo);
			// ΏێЈݒ
			vo.setSelectKCode(dto.getKCode());
			// \
			dto = show(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * LxǗ
	 * @param vo YukyuPersonalCardVoCX^X
	 * @throws Exception
	 */
	private MYukyuDto show(	YukyuPersonalCardVo vo) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		vo.setDefaultValues();
		// l{̎擾
		MKihonDto mKihonDto = getBasisInfo(vo.getSelectKCode());
		// I̐ݒ
		vo.setSelectKName(mKihonDto.getSimei());
		vo.setSelectSectionName(util.getCodeName(mKihonDto.getSCode(), getSectionArrayAll()));
		// DAO
		MYukyuDao dao = new MYukyuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// Ώ۔N̗L擾
		MYukyuDto currentDto = dao.findForKey(vo.getSelectKCode(), util.convDateToString(getCalcPayment()));
		// Lx̃`FbN
		if(!chkExistDto(currentDto)){
			// Ώ۔N̑O擾
			String formerDate = String.valueOf(util.convDateToInteger(
					util.addMonth(getCalcPayment(), -1)));
			currentDto = dao.findForKey(vo.getSelectKCode(), formerDate);
		}
		// VOɏݒ
		if (!chkExistDto(currentDto)) {
			vo.setSelectKCode(mKihonDto.getKCode());
			vo.setSelectKName(mKihonDto.getSimei());
			vo.setSelectSectionName(util.getCodeName(mKihonDto.getSCode(), getSectionArrayAll()));
			vo.setLblCalcYear(String.valueOf(MospUtility.getYear(getCalcPayment())));
			vo.setLblCalcMonth(String.valueOf(MospUtility.getMonth(getCalcPayment())));
		} else {
			vo.setFields(currentDto);
		}
		// Lx񃊃Xg̎擾
		vo.initListInfo();
		List<MYukyuDto> myukyulist = dao.findForList(vo.getSelectKCode(),util.convDateToString(getCalcPayment()));
		vo.setFields(myukyulist);
		// [hݒ
		vo.setMode(YukyuPersonalCardVo.MODE_UPDATE);
		return currentDto;
	}

	/**
	 * XV
	 * @param vo ΏVO
	 * @throws Exception
	 */
	private MYukyuDto update(YukyuPersonalCardVo vo) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// p[^̑ÓmF
		vo.validate();
		// ^vZΏ۔N擾
		String targetDate = util.convDateToString(getCalcPayment());
		// o^
		// DAO
		MYukyuDao dao = new MYukyuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);	
		// DTȌ
		MYukyuDto dto = new MYukyuDto();
		// Lx擾
		MYukyuDto chkDto = dao.findForUpdate(vo.getSelectKCode(), targetDate);
		// Lx̌vZ
		setPaidHolidayCalc(vo);
		if (!chkExistDto(chkDto)) {
			// Lxo^
			vo.setDtoFields(dto, targetDate);
			dao.insert(dto);
		} else {
			// LxXV
			dto = chkDto;
			vo.setDtoFields(dto);
			dao.update(dto);
		}
		// Lx擾
		MYukyuDto retDto = dao.findForKey(dto.getKCode(), String.valueOf(dto.getKyuyoYMD()));
		chkUpdate(retDto);
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		return retDto;
	}

	/**
	 * LxvZ(setDtoFields)
	 * @param vo
	 * @throws Exception
	 */
	private void setPaidHolidayCalc(YukyuPersonalCardVo vo) throws Exception {
		// ΏۓۗLONiύXj= ۗLONiύXOj + t^iONj- piONj
		double targetLY = Double.parseDouble(vo.getHidThisRestLY()) + Double.parseDouble(vo.getTxtThisGetLY()) - Double.parseDouble(vo.getTxtThisDisposeLY());
		// pۗLA0ɖ߂B
		if (targetLY < 0) {
			double reDisposeLY = Double.parseDouble(vo.getTxtThisDisposeLY()) + targetLY;
			vo.setTxtThisDisposeLY(String.valueOf(reDisposeLY));
			vo.setHidThisRestLY(CommonConst.NAM_COMMON_DOUBLE_INITIAL_VALUE);
		} else {
			vo.setHidThisRestLY(String.valueOf(targetLY));
		}
		// ΏۓۗLNiύXj= ۗLNiύXOj + t^iONj- piONj
		double targetTY = Double.parseDouble(vo.getHidThisRestTY()) + Double.parseDouble(vo.getTxtThisGetTY()) - Double.parseDouble(vo.getTxtThisDisposeTY());
		// pۗLA0ɖ߂B
		if (targetTY < 0) {
			double reDisposeTY = Double.parseDouble(vo.getTxtThisDisposeTY()) + targetTY;
			vo.setTxtThisDisposeTY(String.valueOf(reDisposeTY));
			vo.setHidThisRestTY(CommonConst.NAM_COMMON_DOUBLE_INITIAL_VALUE);
		} else {
			vo.setHidThisRestTY(String.valueOf(targetTY));
		}
		// p = piNj+ piONj
		double dispose = Double.parseDouble(vo.getHidDispose()) + Double.parseDouble(vo.getTxtThisDisposeTY()) + Double.parseDouble(vo.getTxtThisDisposeLY());		
		vo.setHidDispose(String.valueOf(dispose));
		// 擾 = 擾iNj+ 擾iONj
		int get = Integer.parseInt(vo.getHidTGet()) + Integer.parseInt(vo.getTxtThisGetTY()) + Integer.parseInt(vo.getTxtThisGetLY());		
		vo.setHidGet(String.valueOf(get));
		return;
	}

}
